#include <iostream>
#include <cstdlib>
#include<cmath>
#include "snaps.h"
#include "mcntl.h"
#include "mfile_open.h"
#include "mkisosu.h"
#include "mkisoritu.h"
#include "option.h"

using namespace std;

#define CHK

static int MAX_NENREI[SAISHUNENDO - SHONENDO + 1][MENJO_JOKYO];

static int MAX_NENREI_BEFORE[MENJO_JOKYO] ={70,70,60,60,60,60,60,60,30,50};
static int MAX_NENREI_AFTER[MENJO_JOKYO] = {70,70,60,60,60,60,60,60,50,50};
static int MAX_NENREI_OP[SAISHUNENDO - SHONENDO + 1][MENJO_JOKYO] ={0};

void noufuritu_3gou_cal();
void noufuritu_1gou_cal(int shubetu);

int noufu_menjo_set( int shubetu , FILE *fp , 
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  );
int noufu_mokuhyo_set( int shubetu , FILE *fp , double noufu_mokuhyo[] );
int tuinou_set(int shubetu , FILE *fp, double tuinouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]);
int kounou_set(int shubetu , FILE *fp , double kounouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]); 
int taishou_mokuhyo_set( int shubetu , FILE *fp , 
			double taishou_wariai_mokuhyo[][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] ,
			double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] );
int maternity_set( FILE *fp, double maternity_ratio[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] );

void taishou_hosei(int nendo_jisseki , double taishou_wariai_mokuhyo[][MENJO_JOKYO] ,
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] , double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] );

void zengaku_noufu_cal(int nendo , double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]); 

double sankyu_taishou_cal( int nendo ,
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  , 
			double maternity_ratio[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] );

void noufu_hosei(double noufu_mokuhyo[] , double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] ,
			double taishou_wariai_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]);

void noufuritu_hiho_make(
			double noufuritu_hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN],
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN]);

double noufuritu_cal(int nendo , int nenrei , int noufu_kubun,
			double noufuritu_hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN],
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double tuinouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double kounouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]);

double taishou_wariai_cal(int nendo, int nenrei , int menjo_jokyo, 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double tuinouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]);

double tuinou_make(int nendo ,int nenrei ,int menjo_jokyo , 
			double tuinouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]);

void noufutest01_out( int shubetu , FILE *fp , 
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] , 
			double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] );

void noufuritu( int shubetu )
{
	int nendo;
	int menjo_jokyo;

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for(menjo_jokyo=SUM ; menjo_jokyo<MENJO_JOKYO ;menjo_jokyo++)
		{
			if(nendo < WAKAMONO_HENKO_NENDO)
			{
				MAX_NENREI[nendo - SHONENDO][menjo_jokyo] = MAX_NENREI_BEFORE[menjo_jokyo];
			}
			else
			{
				MAX_NENREI[nendo - SHONENDO][menjo_jokyo] = MAX_NENREI_AFTER[menjo_jokyo];
			}

			if(menjo_jokyo != SUM && menjo_jokyo != NOUFU && menjo_jokyo != WAKAMONO && menjo_jokyo != SANKYU)
			{
				MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] = MAX_NENREI[nendo - SHONENDO][menjo_jokyo] + encho_year(nendo);
			}
			else
			{
				MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] = MAX_NENREI[nendo - SHONENDO][menjo_jokyo];
			}
		}
	}

	if(shubetu == 3 || shubetu == 6)
	{
		noufuritu_3gou_cal();		
	}

	if(shubetu == 2 || shubetu == 5)
	{
		noufuritu_1gou_cal(shubetu);
	}

	return;

}

void noufuritu_3gou_cal()
{
	int nendo;
	int nenrei;
	int menjo_jokyo;
	int MAX_3GOU_NENREI;
	
	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{

		MAX_3GOU_NENREI = 60 + encho_year( nendo );

		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			for( menjo_jokyo = SUM ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{

				if( nenrei < MAX_3GOU_NENREI )	
				{
					if(menjo_jokyo == NOUFU)
					{
						Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = 1.;
					}	
					else
					{
						Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = 0.;
					}
				}
				else
				{
					Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = 0.;
				}
			}
		}
	}
	return;	
}

void noufuritu_1gou_cal(int shubetu)
{

	int menjo_jokyo; 
	int noufu_kubun;

	int nendo;
	int nenrei;
	int i;
	double d;
	double hiho[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]={0.};
	double jinko[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]={0.};
	double noufuritu[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] = {0.};
	double sankyu_mae_taishou_wariai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};
	double taishou_wariai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};
	double noufuritu_hiho[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] = {0.};
	double tuinouritu_zisseki[TUINOU_NENSU_KUBUN][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};
	double kounouritu_zisseki[KOUNOU_NENSU][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] = {0.};
	double maternity_ratio[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ={0.};
	double noufu_mokuhyo[SAISHUNENDO - SHONENDO + 1] = {0.};
	double noufu_mokuhyo_saishu[SAISHUNENDO - SHONENDO + 1] = {0.};
	double taishou_wariai_mokuhyo[SAISHUNENDO - SHONENDO + 1][MENJO_JOKYO] = {0.};
	double tuinouritu[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};
	double hiho_jurai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]={0.};
	double jinko_jurai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]={0.};
	double noufuritu_jurai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] = {0.};
	double sankyu_mae_taishou_wariai_jurai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};
	double taishou_wariai_jurai[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] = {0.};

	using namespace std;

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			for( menjo_jokyo = SUM ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = 0.;
			}
		}
	}

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] = Sotowaku[shubetu][nendo - SOTOWAKU_SHONENDO][nenrei - MIN_HIHO_NENREI];
			jinko[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] = Sotowaku[shubetu - 1][nendo - SOTOWAKU_SHONENDO][nenrei - MIN_HIHO_NENREI];

			if(Option == 1)
			{
				hiho_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] = Sotowaku_Jurai[shubetu][nendo - SOTOWAKU_SHONENDO][nenrei - MIN_HIHO_NENREI];
				jinko_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] = Sotowaku_Jurai[shubetu - 1][nendo - SOTOWAKU_SHONENDO][nenrei - MIN_HIHO_NENREI];
			}
		}
	}

	if(Option != 1)
	{
		noufu_menjo_set( shubetu , fp_in[NOUFU_MENJO_WARIAI] , noufuritu , sankyu_mae_taishou_wariai);
	}
	else
	{
		noufu_menjo_set( shubetu , fp_in[NOUFU_MENJO_WARIAI_OP] , noufuritu , sankyu_mae_taishou_wariai );
		noufu_menjo_set( shubetu , fp_in[NOUFU_MENJO_WARIAI] , noufuritu_jurai , sankyu_mae_taishou_wariai_jurai );

		for( nendo =SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
		{
			for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
			{
				for( menjo_jokyo = SUM ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
				{
					if(nenrei >= MAX_KYOSHUTU_NENREI + encho_year(nendo))
					{
						sankyu_mae_taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo]
						= sankyu_mae_taishou_wariai_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
					}
				}

				for(noufu_kubun =SUM ; noufu_kubun < NOUFU_KUBUN ;noufu_kubun++)
				{
					if(nenrei >= MAX_KYOSHUTU_NENREI + encho_year(nendo))
					{
						noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] = noufuritu_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];
					}
				}
			}
		}
	}

	noufu_mokuhyo_set( shubetu , fp_in[MOKUHYOUNOUFU] , noufu_mokuhyo );
	noufu_mokuhyo_set( shubetu , fp_in[MOKUHYOUNOUFUSAISHU] , noufu_mokuhyo_saishu );

	if( Part == 1 ){
		for(nendo = Part_Year_1 ;nendo <=SAISHUNENDO ; nendo++)
		{
			if(Part_S == 2){
				noufu_mokuhyo[nendo - SHONENDO] += 0.002;
				noufu_mokuhyo_saishu[nendo - SHONENDO] += 0.002;
			}
			if(Part_S == 3){
				noufu_mokuhyo[nendo - SHONENDO] += 0.004;
				noufu_mokuhyo_saishu[nendo - SHONENDO] += 0.004;
			}
			if(Part_S == 4){
				noufu_mokuhyo[nendo - SHONENDO] += 0.022;
				noufu_mokuhyo_saishu[nendo - SHONENDO] += 0.024;
			}
		}
	}

	tuinou_set(shubetu , fp_in[TUINOU] , tuinouritu_zisseki);

	kounou_set(shubetu , fp_in[KOUNOURITU], kounouritu_zisseki);

	taishou_mokuhyo_set( shubetu , fp_in[TAISHOUSHA] , taishou_wariai_mokuhyo ,hiho ,jinko );	

	if(shubetu == 5)
	{
		maternity_set( fp_in[BIRTH] , maternity_ratio );
	}

	if(Option != 1)
	{
		taishou_hosei( NENDO_JISSEKI , taishou_wariai_mokuhyo , sankyu_mae_taishou_wariai , hiho , jinko);
	}
	else
	{
		taishou_hosei( NENDO_JISSEKI , taishou_wariai_mokuhyo , sankyu_mae_taishou_wariai_jurai , hiho_jurai , jinko_jurai);

		for( nendo =SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
		{
			for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
			{
				for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
				{
					
					if( nenrei >= MAX_KYOSHUTU_NENREI && nenrei < MAX_KYOSHUTU_NENREI + encho_year(nendo))
					{
						if(menjo_jokyo != NOUFU)
						{
							d = 0.;
							for(i=55 ;i<60 ;i++)
							{
								d += sankyu_mae_taishou_wariai_jurai[nendo - SHONENDO][i- MIN_HIHO_NENREI][menjo_jokyo];
							}
							d /= 5.0;

							sankyu_mae_taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = d;	
						}
					}
					else
					{
						sankyu_mae_taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = sankyu_mae_taishou_wariai_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];	
					}

				}
			}
			zengaku_noufu_cal(nendo,taishou_wariai);
		}						
	}

	for( nendo =SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
		{
			for( menjo_jokyo = SUM ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = sankyu_mae_taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];	
			}
		}

		if( shubetu == 5 && nendo >= SANKYU_HENKO_NENDO )	
		{   
			Hiho_Sankyu_Sum[nendo - SHONENDO] = sankyu_taishou_cal( nendo , taishou_wariai , maternity_ratio ,hiho ); 
		}
		if(Option == 1)
		{
			for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
			{
				for( menjo_jokyo = SUM ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
				{
					taishou_wariai_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
						= sankyu_mae_taishou_wariai_jurai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];	
				}
			}
			if( shubetu == 5 && nendo >= SANKYU_HENKO_NENDO )	
			{   
				sankyu_taishou_cal( nendo , taishou_wariai_jurai , maternity_ratio ,hiho_jurai ); 
			}
		}
	}

	if(Option != 1)
	{
		noufu_hosei( noufu_mokuhyo , noufuritu ,  taishou_wariai , hiho , taishou_wariai , hiho );
		noufutest01_out(shubetu , fp_out[NOUFUTEST1] , noufuritu , taishou_wariai , hiho , jinko);
		noufu_hosei( noufu_mokuhyo_saishu , noufuritu ,  taishou_wariai , hiho , taishou_wariai , hiho );
		noufutest01_out(shubetu , fp_out[NOUFUTEST3] , noufuritu , taishou_wariai , hiho , jinko);
	}
	else
	{
		noufu_hosei( noufu_mokuhyo , noufuritu , taishou_wariai , hiho , taishou_wariai_jurai , hiho_jurai );
		noufu_hosei( noufu_mokuhyo , noufuritu_jurai , taishou_wariai , hiho , taishou_wariai_jurai , hiho_jurai );
		noufutest01_out(shubetu , fp_out[NOUFUTEST1] , noufuritu , taishou_wariai , hiho , jinko);
		noufu_hosei( noufu_mokuhyo_saishu , noufuritu , taishou_wariai , hiho , taishou_wariai_jurai , hiho_jurai );
		noufu_hosei( noufu_mokuhyo_saishu , noufuritu_jurai , taishou_wariai , hiho , taishou_wariai_jurai , hiho_jurai );
		noufutest01_out(shubetu , fp_out[NOUFUTEST3] , noufuritu , taishou_wariai , hiho , jinko);
	}

	noufuritu_hiho_make(noufuritu_hiho,taishou_wariai,noufuritu);

	for( nendo = SUIKEISHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI - 1 ; nenrei++ )
		{
			for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				tuinouritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
						=tuinou_make(nendo ,nenrei , menjo_jokyo , tuinouritu_zisseki , taishou_wariai);
			}
		}
	}
	
	for( nendo = SUIKEISHONENDO ; nendo <= SUIKEISAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )	
		{
			for( noufu_kubun = START ; noufu_kubun < NOUFU_KUBUN ; noufu_kubun++ )
			{
				Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
					= noufuritu_cal(nendo , nenrei , noufu_kubun , noufuritu_hiho , taishou_wariai , tuinouritu, kounouritu_zisseki[SUM]);
			}

			for( menjo_jokyo = NOUFU_KUBUN ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
					= taishou_wariai_cal(nendo , nenrei , menjo_jokyo , taishou_wariai , tuinouritu);
			}
		}
	}

	fprintf( fp_out[NOUFUTEST2] , "Nx,N," );
	fprintf( fp_out[NOUFUTEST2] , "یҐ,[t(Ə*[t),SƗ,3/4Ɨ(Ə*[t),Ɨ,1/4Ɨ,(Čf)[(Ə*[t),\n" );
	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			fprintf( fp_out[NOUFUTEST2] , "%d,%d," , nendo , nenrei );
			fprintf( fp_out[NOUFUTEST2] , "%11.9e," , hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]);
			fprintf( fp_out[NOUFUTEST2] , "%11.9e," , Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU] );
			fprintf( fp_out[NOUFUTEST2] , "%11.9e," , 
						Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][MENJO_HOUTEI] + Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][MENJO_SHINSEI]);
				
			for( menjo_jokyo = MENJO_3_4 ; menjo_jokyo <= MENJO_1_4 ; menjo_jokyo++ )
			{
				fprintf( fp_out[NOUFUTEST2] , "%11.9e," , Noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] );
			}

			fprintf( fp_out[NOUFUTEST2] , "%11.9e," , kounouritu_zisseki[SUM][nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU]);
			fprintf( fp_out[NOUFUTEST2] , "\n" );
		}
	}
}

int noufu_menjo_set( int shubetu , FILE *fp , 
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  )
{

	int nendo;
	int nenrei;
	int noufu_kubun;
	int menjo_jokyo;
	int data_number;
	double buffer[BUFFER_MAX];

	int NOUFURITU_COLUMN =1 ;
	int TAISHOU_COLUMN =5;
	int SKIP_ROW	= 2;

	if(shubetu == 2)
	{
		data_skip(fp,SKIP_ROW);
	}

	for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
	{
		buffer_set2( buffer , fp ,&data_number , shubetu ,nenrei , "Nʔ[tEΏێҊ"); 

		for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
		{
			for( noufu_kubun = START ; noufu_kubun < NOUFU_KUBUN ; noufu_kubun++ )
			{
				if(nenrei < MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo])
				{
					noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] = buffer[ NOUFURITU_COLUMN + noufu_kubun ];
				}
				else
				{
					noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] = 0.;
				}
			}

			for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				if(nenrei < MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] )
				{
						taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = buffer[TAISHOU_COLUMN + menjo_jokyo];	
				}
				else
				{
					taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = 0.;	
				}
			}
		}
	}

	for(nenrei = MAX_NENREI_BEFORE[WAKAMONO] ; nenrei < MAX_NENREI_AFTER[WAKAMONO] ; nenrei++)
	{
		taishou_wariai[WAKAMONO_HENKO_NENDO - SHONENDO][nenrei - MIN_HIHO_NENREI][WAKAMONO] *= WAKAMONO_HENKO_RITU;
	}

	return 0;
}

int noufu_mokuhyo_set( int  shubetu , FILE *fp , double noufu_mokuhyo[] )
{
	int nendo;
	int data_number;
	double buffer[BUFFER_MAX];
	int MOKUHYO_COLUMN = 2;
	int SKIP_ROW = 1;

	if(shubetu == 2)
	{
		data_skip(fp,SKIP_ROW);
	}

	for(nendo = SHONENDO ;nendo <=SAISHUNENDO ; nendo++)
	{
		buffer_set1( buffer , fp ,&data_number , shubetu , "ڕW[t"); 
		noufu_mokuhyo[nendo - SHONENDO] = buffer[MOKUHYO_COLUMN];
	}

	return 0;
}

int tuinou_set(int shubetu , FILE *fp, double tuinouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO])
{
	int nendo;
	int nenrei;
	int menjo_jokyo;
	int data_number;
	int counter;
	double buffer[BUFFER_MAX];
	int SKIP_ROW	= 2;

	if(shubetu == 2)
	{
		data_skip(fp,SKIP_ROW);
	}


	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		buffer_set2( buffer , fp ,&data_number , shubetu ,nendo , "ǔ["); 

		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			for( counter = 0 ; counter < TUINOU_NENSU_KUBUN ; counter++ )
			{
				for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
				{
					tuinouritu_zisseki[counter][nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = buffer[menjo_jokyo * 2 + counter];
				}				
			}
		}
	}

	return 0;
}

int kounou_set(int shubetu , FILE *fp , double kounouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1])
{
	double kounou_ritu;
	int nendo;
	int nenrei;
	int data_number;
	double buffer[BUFFER_MAX];
	int MOKUHYO_COLUMN = 2;
	int SKIP_ROW	= 1;

	if(shubetu == 2)
	{
		data_skip(fp,SKIP_ROW);
	}

	for(nendo = SHONENDO ;nendo <=SAISHUNENDO ; nendo++)
	{
		buffer_set1( buffer , fp ,&data_number , shubetu , "["); 
		kounou_ritu = buffer[MOKUHYO_COLUMN];

		for( nenrei = 22 ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
		{
			if(nenrei < 24)
			{
				kounouritu_zisseki[SUM][nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] += kounou_ritu *(nenrei - 21) / 3.0 ;
			}
			else
			{
				kounouritu_zisseki[SUM][nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] += kounou_ritu;
			}
		}
	}
	return 0;
}

int taishou_mokuhyo_set( int shubetu , FILE *fp , 
			double taishou_wariai_mokuhyo[][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] ,
			double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )
{

	int nendo;
	int menjo_jokyo;
	int data_number;
	double buffer[BUFFER_MAX];
	double taishousha[NENDO_JISSEKI - SHONENDO + 1][MENJO_JOKYO] = {0.};
	double jinko_jisseki = 0.;
	double jinko_nendo = 0.;
	double hiho_nendo = 0.;

	int SKIP_ROW	= 1;

	if(shubetu == 2)
	{
		data_skip(fp,SKIP_ROW);
	}

	for( nendo = SUIKEISHONENDO ; nendo <= NENDO_JISSEKI ; nendo++ )
	{
		buffer_set2( buffer , fp ,&data_number , shubetu ,nendo , "̖Ə󋵕ʑΏێҐ"); 

		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			if (menjo_jokyo != NOUFU)
			{
				taishousha[nendo - SHONENDO][menjo_jokyo] = buffer[menjo_jokyo + 1];
			}
		}
	}

	jinko_jisseki = array_sum(jinko[NENDO_JISSEKI - SHONENDO] , MIN_HIHO_NENREI - MIN_HIHO_NENREI , MAX_KYOSHUTU_NENREI - MIN_HIHO_NENREI);

	for( nendo = SUIKEISHONENDO ; nendo <= SUIKEISAISHUNENDO ; nendo++ )
	{
		jinko_nendo = array_sum( jinko[nendo - SHONENDO] , MIN_HIHO_NENREI - MIN_HIHO_NENREI , MAX_KYOSHUTU_NENREI - MIN_HIHO_NENREI);
		hiho_nendo = array_sum( hiho[nendo - SHONENDO] , MIN_HIHO_NENREI - MIN_HIHO_NENREI , MAX_KYOSHUTU_NENREI - MIN_HIHO_NENREI);

		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			if(nendo <= NENDO_JISSEKI)
			{
				taishou_wariai_mokuhyo[nendo - SHONENDO ][menjo_jokyo] 
					= fdiv( taishousha[nendo - SHONENDO][menjo_jokyo] , hiho_nendo );
			}
			else
			{
				taishou_wariai_mokuhyo[nendo - SHONENDO ][menjo_jokyo] = taishou_wariai_mokuhyo[NENDO_JISSEKI - SHONENDO ][menjo_jokyo];
			
				if(menjo_jokyo == MENJO_HOUTEI)
				{
					taishou_wariai_mokuhyo[nendo - SHONENDO ][MENJO_HOUTEI]
						= taishousha[NENDO_JISSEKI - SHONENDO][MENJO_HOUTEI] * fdiv(jinko_nendo , jinko_jisseki );
					taishou_wariai_mokuhyo[nendo - SHONENDO ][MENJO_HOUTEI] = fdiv(	taishou_wariai_mokuhyo[nendo - SHONENDO ][MENJO_HOUTEI] , hiho_nendo );
				}
			}
		}

		taishou_wariai_mokuhyo[nendo - SHONENDO ][NOUFU] = 1.0;

		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			if(menjo_jokyo != NOUFU)
			{
				taishou_wariai_mokuhyo[nendo - SHONENDO ][NOUFU] -= taishou_wariai_mokuhyo[nendo - SHONENDO][menjo_jokyo];	
			}
		}

	}

	return 0;
}

int maternity_set( FILE *fp, double maternity_ratio[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] )
{	
	int nendo;
	int nenrei;
	int menjo_jokyo;
	int data_number;
	double buffer[BUFFER_MAX];
	double birth_ratio[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1]={0.};

	int SKIP_ROW	= 2;
	int MIN_BIRTH_NENREI = 15;
	int MAX_BIRTH_NENREI = 50;
	double hosei[MENJO_JOKYO] = {0. ,1./3. ,1./3.,1./3.,1./3.,1./12. ,1./3.,0. ,1./3., 0.  };

	data_skip(fp, SKIP_ROW);

	for(nenrei = MIN_BIRTH_NENREI ;nenrei < MAX_BIRTH_NENREI ; nenrei++)
	{
		buffer_set1( buffer , fp ,&data_number , nenrei , "o"); 

		if( nenrei >= MIN_HIHO_NENREI && nenrei < MAX_HIHO_NENREI )
		{
			for(nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++)
			{
				birth_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] = buffer[nendo - SHONENDO + 1];
			}
		}
	}

	for(nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++)
	{
		for(nenrei = MIN_HIHO_NENREI ;nenrei <MAX_HIHO_NENREI ; nenrei++)
		{
			for(menjo_jokyo=START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++)
			{
				maternity_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = birth_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * hosei[menjo_jokyo];
			}


		}
	}

	return 0;
}

void taishou_hosei(int nendo_jisseki , double taishou_wariai_mokuhyo[][MENJO_JOKYO] ,
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] , double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )
{
	int nendo;
	int nenrei;
	int menjo_jokyo;

	double mokuhyo;
	double gokei;
	double non_gokei;

	double hikiageritu;
	double ninzu;

	for(nendo = SHONENDO ; nendo <=nendo_jisseki ; nendo++)
	{
		for(menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++)
		{
			if( menjo_jokyo != NOUFU ) 
			{
				gokei = 0.;
				non_gokei = 0.;

				mokuhyo = taishou_wariai_mokuhyo[nendo - SHONENDO ][menjo_jokyo] * array_sum( hiho[nendo - SHONENDO] , MIN_HIHO_NENREI - MIN_HIHO_NENREI , MAX_KYOSHUTU_NENREI - MIN_HIHO_NENREI);
				for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
				{
					gokei += taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI];
					non_gokei += (1.0 - taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] )
								* hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI];
				}
				
				if( menjo_jokyo == GAKUSEI)
				{
					for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
					{
						taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] *= fdiv(mokuhyo , gokei);
					}
				}
				else
				{
					if ( mokuhyo <= gokei )
					{
						for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
						{
							taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] *= fdiv(mokuhyo , gokei);
						}
					}
					else
					{
						hikiageritu = fdiv( mokuhyo - gokei , non_gokei) ;
						for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
						{
							ninzu = hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
											+ hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * (1.0 - taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] ) * hikiageritu ;
	
							taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = fdiv(ninzu ,hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] );
						}
					}
				}
			}

			zengaku_noufu_cal(nendo,taishou_wariai);
		}

	}

	for( nendo = nendo_jisseki + 1 ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
		{

			for(menjo_jokyo =START ; menjo_jokyo < MENJO_JOKYO ;menjo_jokyo++)
			{
				if(menjo_jokyo == MENJO_HOUTEI)
				{
					taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
						= taishou_wariai[nendo_jisseki - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * hiho[nendo_jisseki - SHONENDO][nenrei - MIN_HIHO_NENREI] 
							* fdiv( jinko[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] , jinko[nendo_jisseki - SHONENDO][nenrei - MIN_HIHO_NENREI] );
					taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] *= fdiv(1.0, hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]);
				}
				else if(menjo_jokyo != NOUFU)
				{
					taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = taishou_wariai[nendo_jisseki - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] ;
				}
			}
		}

		zengaku_noufu_cal(nendo,taishou_wariai);
	}

	return;
}

void zengaku_noufu_cal(int nendo , double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO])
{
	int nenrei;
	int menjo_jokyo;

	for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_HIHO_NENREI ; nenrei++ )
	{
		taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU] = 1.;

		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			if( menjo_jokyo != NOUFU)
			{
				taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU] -= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
			}
		}

	}

	return;
}	

void taishou_hosei_kyu( double taishou_wariai_mokuhyo[][MENJO_JOKYO] ,
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] ,
			double taishou_wariai_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , double hiho_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )	
{
	int nendo ;
	int nenrei;
	int menjo_jokyo;

	double mokuhyo;
	double gokei;
	double non_gokei;

	double hikiageritu;
	double ninzu;

 	for( nendo = SUIKEISHONENDO ; nendo <= SUIKEISAISHUNENDO ; nendo++ )
	{

		for(menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++)
		{
			if( menjo_jokyo != NOUFU ) 
			{
				gokei = 0.;
				non_gokei = 0.;

				mokuhyo = taishou_wariai_mokuhyo[nendo - SHONENDO ][menjo_jokyo] * array_sum( hiho_hosei[nendo - SHONENDO] , MIN_HIHO_NENREI - MIN_HIHO_NENREI ,
											 	MAX_NENREI[nendo - SHONENDO][menjo_jokyo]  - MIN_HIHO_NENREI);

				for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][menjo_jokyo]  ; nenrei++ )
				{
					gokei += taishou_wariai_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * hiho_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI];
					non_gokei += (1.0 - taishou_wariai_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] )
								* hiho_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI];
				}
				
				if( menjo_jokyo == GAKUSEI)
				{
					for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
					{
						taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] *= fdiv(mokuhyo , gokei);
					}
				}
				else
				{
					if ( mokuhyo <= gokei )
					{
						for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
						{
							taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] *= fdiv(mokuhyo , gokei);
						}
					}
					else
					{

						hikiageritu = fdiv( mokuhyo - gokei , non_gokei) ;

						for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][menjo_jokyo] ; nenrei++ )
						{
							ninzu = hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
											+ hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * (1.0 - taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] ) * hikiageritu ;

							taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] = fdiv(ninzu ,hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] );
						}

					}
				}
			}
		}

		for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][NOUFU]  ; nenrei++ )
		{
			taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU] = 1.;

			for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
			{
				if( menjo_jokyo != NOUFU)
				{
					taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU] -= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
				}
			}
		}

	}

	return;
}

double sankyu_taishou_cal( int nendo ,
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  , 
			double maternity_ratio[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )
{
	int nenrei;
	int menjo_jokyo;
	double sankyu_ninzu = 0.;

	for(nenrei = MIN_HIHO_NENREI ;nenrei < MAX_HIHO_NENREI ;nenrei++)
	{
		for(menjo_jokyo=START ;menjo_jokyo < MENJO_JOKYO ;menjo_jokyo++)
		{
			if(menjo_jokyo != SANKYU)
			{
				sankyu_ninzu += hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] 
						* taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * maternity_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] ;

				taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SANKYU] 
					+= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * maternity_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] ; 

				taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] 
					-= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo] * maternity_ratio[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo]  ; 
			}
		}
	}

	return sankyu_ninzu;
}

void noufu_hosei(double noufu_mokuhyo[] , double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  , double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] ,
			double taishou_wariai_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO]  , double hiho_hosei[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )
{

	int nendo ;
	int nenrei;
	int noufu_kubun;

	double mokuhyo;
	double gokei;
	double non_gokei;

	double hikiageritu;
	double ninzu;
	double noufu_taishou;

	double noufusha[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN]={0.};
	double noufu_taishousha[SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN]={0.};

	for( nendo = SUIKEISHONENDO ; nendo <= SUIKEISAISHUNENDO ; nendo++ )
	{
		mokuhyo = 0.;
		gokei = 0.;
		non_gokei = 0.;
		noufu_taishou = 0.;

		for (noufu_kubun = START ; noufu_kubun <NOUFU_KUBUN ; noufu_kubun++)
		{
			for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][noufu_kubun] ; nenrei++ )
			{
				noufu_taishou += taishou_wariai_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * hiho_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] ;			
			}
		}

		mokuhyo = noufu_mokuhyo[nendo - SHONENDO] * noufu_taishou;

		for (noufu_kubun = START ; noufu_kubun <NOUFU_KUBUN ; noufu_kubun++)
		{
			for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI[nendo - SHONENDO][noufu_kubun]; nenrei++ )		
			{
				gokei += noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
								* taishou_wariai_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * hiho_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]; 

				non_gokei += (1.0 - noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]  )
								* taishou_wariai_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * hiho_hosei[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]; 
			}
		}	

		if ( mokuhyo <= gokei )
		{
			for (noufu_kubun = START ; noufu_kubun < NOUFU_KUBUN ; noufu_kubun++)
			{
				for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][noufu_kubun] ; nenrei++ )
				{
					noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] *= fdiv(mokuhyo , gokei);
				}
			}
		}
		else
		{
			hikiageritu = fdiv( mokuhyo - gokei , non_gokei) ;

			for (noufu_kubun = START ; noufu_kubun <NOUFU_KUBUN ; noufu_kubun++)
			{
				for( nenrei = MIN_HIHO_NENREI ; nenrei < MAX_NENREI_OP[nendo - SHONENDO][noufu_kubun] ; nenrei++ )
				{
					ninzu = hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
											* noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
									+ hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]
											* (1.0 - noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] ) * hikiageritu ;

					noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
								= fdiv(ninzu ,hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI] * taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]  );
				}
			}
		}

		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			for(noufu_kubun=START ;noufu_kubun < NOUFU_KUBUN ;noufu_kubun++)
			{
				noufu_taishousha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] 
					= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI];
				noufu_taishousha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM]
					+= noufu_taishousha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];

				noufusha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]  
					= noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * noufu_taishousha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] ;
				noufusha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM]
					+= noufusha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];
			}

			noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM] 
				= fdiv(noufusha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM] , noufu_taishousha[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM]);  
		}
	}

	return ;
}

void noufutest01_out( int shubetu , FILE *fp , 
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] , 
			double jinko[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1] )
{

	char *hyoto[] = {
			"","Nx","N",		
			"[tivj","[ti[tj","[ti3/4Əj","[tizƏj","[ti1/4Əj",
			"یҁi[tΏہj","یҁiSz[tj","یҁi3/4Əj","یҁizƏj","یҁi1/4Əj","یҁi@Əj","یҁi\)","یҁiwj","یҁi)",
			"یҁiYxj","l","Og",
			"ƏiSzƏj","Əi3/4Əj","ƏizƏj","Əi1/4Əj","Əiwj","Əiҁj","ƏiYxj"
			};


	int hyoto_num;

	int nendo;
	int nenrei;
	int noufu_kubun;
	int menjo_jokyo;

	int i;


	hyoto_num = (sizeof hyoto) /(sizeof hyoto[0]);

	if( shubetu == 2 )
	{
		fprintf( fp , "ǔ[O ZԍF%s oρF%s OgF%s\n",KOKUNEN ,ECON ,SOTOWAKU);

		for(i=0;i<hyoto_num - 1;i++)
		{
			fprintf(fp,"%s,",hyoto[i]);
		}

		fprintf(fp,"%s\n",hyoto[hyoto_num - 1]);
	}

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
		{
			fprintf(fp, "%d,%d,%d", shubetu, nendo, nenrei );

			for(noufu_kubun = SUM ;noufu_kubun < NOUFU_KUBUN ; noufu_kubun++)
			{
				fprintf(fp, ", %11.9e",noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]);
			}

			for(noufu_kubun = SUM ; noufu_kubun < MENJO_JOKYO ; noufu_kubun++)
			{
				fprintf(fp, ", %11.9e",taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun] * hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]);
			}

			fprintf(fp, ",%11.9e,%11.9e",jinko[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI],hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]);

			fprintf(fp,", %11.9e",taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][MENJO_HOUTEI] + taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][MENJO_SHINSEI]);
				
			for(menjo_jokyo = START ;menjo_jokyo < MENJO_JOKYO ;menjo_jokyo++)
			{
				if(menjo_jokyo != NOUFU && menjo_jokyo != MENJO_HOUTEI && menjo_jokyo != MENJO_SHINSEI)
				{
					fprintf(fp,", %11.9e",taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo]);
				}
			}

			fprintf(fp,"\n");
		}
	}

	return;
}

void noufuritu_hiho_make(
			double noufuritu_hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN],
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double noufuritu[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN])
{
	int nendo;
	int nenrei;
	int noufu_kubun;
		
	for( nendo = SUIKEISHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI - 1 ; nenrei++ )
		{
			for( noufu_kubun = START ; noufu_kubun < NOUFU_KUBUN ; noufu_kubun++ )
			{
				noufuritu_hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]
					= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun]
						* noufuritu[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];

				noufuritu_hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SUM] += noufuritu_hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];
			}
		}
	}

	return;
}

double tuinou_make(int nendo ,int nenrei ,int menjo_jokyo , 
			double tuinouritu_zisseki[][SAISHUNENDO - SHONENDO + 1][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] , 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO])
{
	int counter;
	int tuinou_kubun;
	double value = 0.;

	if(menjo_jokyo !=NOUFU && menjo_jokyo != SANKYU)
	{
		for( counter =0 ; counter <= TUINOU_NENSU ;counter++ )
		{
			tuinou_kubun = (counter == 0) ? 0: 1 ;

			value += tuinouritu_zisseki[tuinou_kubun][nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
		}

		value *= taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];

	}

	return value;
}	

double noufuritu_cal(int nendo , int nenrei , int noufu_kubun,
			double noufuritu_hiho[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][NOUFU_KUBUN],
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double tuinouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO] ,
			double kounouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1])
{
	int menjo_jokyo;
	double value=0.;

	if(noufu_kubun >= NOUFU_KUBUN)
	{
		printf("noufuirtu_caĺAی[t̂敪vZΏۂłBnoufu_kuubun=%d\n",noufu_kubun);
		exit(1);
	}

	value = noufuritu_hiho[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];

	if(noufu_kubun == NOUFU)
	{
		for( menjo_jokyo = START ; menjo_jokyo < MENJO_JOKYO ; menjo_jokyo++ )
		{
			if (menjo_jokyo != NOUFU && menjo_jokyo != SANKYU )
			{
				value += tuinouritu_zisseki[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
			}
		}

		value += kounouritu_zisseki[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI]*taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][NOUFU];
		value += taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][SANKYU];

	}
	else
	{
		value -= tuinouritu_zisseki[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][noufu_kubun];
	}

	return value;
}

double taishou_wariai_cal(int nendo, int nenrei , int menjo_jokyo, 
			double taishou_wariai[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO],
			double tuinouritu_zisseki[][MAX_HIHO_NENREI - MIN_HIHO_NENREI + 1][MENJO_JOKYO])
{
	double value = 0.;

	if(menjo_jokyo < NOUFU_KUBUN || menjo_jokyo >= MENJO_JOKYO)
	{
		printf("taishou_wariai_caĺAی[t̂Ȃ敪vZΏۂłBmenjo_jokyo=%d\n",menjo_jokyo);
		exit(1);
	}

	value = taishou_wariai[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];

	if(menjo_jokyo != SANKYU)
	{
		value -= tuinouritu_zisseki[nendo - SHONENDO][nenrei - MIN_HIHO_NENREI][menjo_jokyo];
	}

	return value;

}

